/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.calculator;

import ch.icit.pegasus.server.core.calculator.IArticleCharge;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IPackagingQuantity;
import ch.icit.pegasus.server.core.calculator.IPackagingQuantityBase;
import ch.icit.pegasus.server.core.calculator.IPurchaseOrderPosition;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IRecipeVariant;
import ch.icit.pegasus.server.core.calculator.IStoreQuantity;
import ch.icit.pegasus.server.core.calculator.ISupplierCondition;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.IUnitSystem;
import ch.icit.pegasus.server.core.exception.InternalServerException;
import ch.icit.pegasus.server.core.exception.UnitNotInPackagingQuantitiesException;
import ch.icit.pegasus.server.core.exception.ValidationException;
import ch.icit.pegasus.server.core.test.annotations.PegasusTested;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class UnitCalculator {
    public static final double DOUBLE_PRECISION = 1.0E-7;

    public static double roundWithDoublePrecision(double toBeRounded, IUnit currentUnit) {
        double maxSubUnitFactor = 1.0;
        IUnit unit = currentUnit;
        while (unit.getSubUnit() != null) {
            unit = unit.getSubUnit();
            maxSubUnitFactor *= (double)unit.getConversionFactor().intValue();
        }
        double usedPrecisionFactor = maxSubUnitFactor > 0.01 ? 1.0E-5 : 1.0E-7;
        return UnitCalculator.roundWithGivenPrecision(toBeRounded, usedPrecisionFactor);
    }

    private static double roundWithGivenPrecision(double toBeRounded, double precision) {
        double convert = toBeRounded;
        double ceiledConvert = Math.ceil(convert);
        double flooredConvert = Math.floor(convert);
        if (Math.abs(ceiledConvert - convert) <= precision) {
            return Math.ceil(convert);
        }
        if (Math.abs(flooredConvert - convert) <= precision) {
            return Math.floor(convert);
        }
        return convert;
    }

    public static double roundWithDoublePrecision(double toBeRounded) {
        return UnitCalculator.roundWithGivenPrecision(toBeRounded, 1.0E-7);
    }

    public static boolean isDoubleEquals(double v1, double v2) {
        return Math.abs(v1 - v2) < 1.0E-7;
    }

    public static boolean isEqual(List<? extends IPackagingQuantity> conversionA, List<? extends IPackagingQuantity> conversionB) {
        Collections.sort(conversionA, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        Collections.sort(conversionB, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        if (conversionA.size() != conversionB.size()) {
            return false;
        }
        int size = conversionA.size();
        for (int i = 0; i < size; ++i) {
            if (!conversionA.get(i).getUnit().equals(conversionB.get(i).getUnit())) {
                return false;
            }
            if (!conversionA.get(i).getAmount().equals(conversionB.get(i).getAmount())) {
                return false;
            }
            if (conversionA.get(i).getSequenceNumber() == conversionB.get(i).getSequenceNumber()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualButSequenceNumberIsDiffrent(List<? extends IPackagingQuantity> conversionA, List<? extends IPackagingQuantity> conversionB) {
        Collections.sort(conversionA, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        Collections.sort(conversionB, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        if (conversionA.size() != conversionB.size()) {
            return false;
        }
        int size = conversionA.size();
        for (int i = 0; i < size; ++i) {
            if (!conversionA.get(i).getUnit().equals(conversionB.get(i).getUnit())) {
                return false;
            }
            if (conversionA.get(i).getAmount().equals(conversionB.get(i).getAmount())) continue;
            return false;
        }
        return !UnitCalculator.isEqual(conversionA, conversionB);
    }

    public static Integer hashCodeOfConversion(List<? extends IPackagingQuantity> conversion) {
        Integer prime = 31;
        Integer result = 1;
        for (IPackagingQuantity iPackagingQuantity : conversion) {
            result = prime * result + (iPackagingQuantity.getSequenceNumber() == null ? 0 : iPackagingQuantity.getSequenceNumber().hashCode());
            result = prime * result + (iPackagingQuantity.getAmount() == null ? 0 : iPackagingQuantity.getAmount().hashCode());
            result = prime * result + (iPackagingQuantity.getUnit() == null ? 0 : iPackagingQuantity.getUnit().hashCode());
        }
        return result;
    }

    public static IStoreQuantity normalizeToStoreQuantity(IQuantity quantity, IBasicArticle article, List<? extends IPackagingQuantity> conversion) {
        IQuantity iQuantity = UnitCalculator.normalizeQuantity(quantity, article, conversion);
        return UnitCalculator.convert(article, conversion, iQuantity);
    }

    public static IQuantity normalizeQuantity(IQuantity quantity, IBasicArticle article, List<? extends IPackagingQuantity> conversion) {
        double q;
        IQuantity qq = quantity.newQuantity(quantity.getAmount(), quantity.getUnit());
        if (article == null) {
            return qq;
        }
        if (conversion.isEmpty()) {
            return qq;
        }
        if (!conversion.get(0).getUnit().equals(qq.getUnit())) {
            q = UnitCalculator.convert(article, qq, conversion, conversion.get(0).getUnit(), conversion);
            qq = qq.newQuantity(q, conversion.get(0).getUnit());
        }
        if (qq.getAmount() >= 1.0) {
            return qq;
        }
        if (qq.getAmount() == 0.0) {
            return qq;
        }
        while (qq.getUnit().getSubUnit() != null && qq.getAmount() < 1.0) {
            q = UnitCalculator.convert(article, qq, conversion, qq.getUnit().getSubUnit(), conversion);
            qq = qq.newQuantity(q, qq.getUnit().getSubUnit());
        }
        if (qq.getAmount() >= 1.0) {
            return qq;
        }
        ArrayList<? extends IPackagingQuantity> packN = new ArrayList<IPackagingQuantity>(conversion);
        for (IPackagingQuantity iPackagingQuantity : packN) {
            double q2 = UnitCalculator.convert(article, qq, conversion, iPackagingQuantity.getUnit(), conversion);
            if ((qq = qq.newQuantity(q2, iPackagingQuantity.getUnit())).getAmount() >= 1.0) {
                return qq;
            }
            while (qq.getUnit().getSubUnit() != null && qq.getAmount() < 1.0) {
                q2 = UnitCalculator.convert(article, qq, conversion, iPackagingQuantity.getUnit(), conversion);
                qq = qq.newQuantity(q2, iPackagingQuantity.getUnit());
            }
            if (!(qq.getAmount() >= 1.0)) continue;
            return qq;
        }
        return qq;
    }

    public static boolean isUnitInArticlesPackagingTableAtTime(IBasicArticle article, IUnit targetUnit, Timestamp validityDate) throws UnitNotInPackagingQuantitiesException {
        return UnitCalculator.isUnitInArticlesPackagingTableAtTime(article, targetUnit, new Date(validityDate.getTime()));
    }

    public static boolean isUnitInArticlesPackagingTableAtTime(IBasicArticle article, IUnit targetUnit, Date validityDate) throws UnitNotInPackagingQuantitiesException {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        List<? extends IPackagingQuantity> packagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, validityDate);
        return UnitCalculator.isUnitInArticlesPackagingTable(article, targetUnit, packagingQuantities);
    }

    public static boolean isUnitInArticlesPackagingTable(IBasicArticle article, IUnit targetUnit, List<? extends IPackagingQuantity> packagingQuantities) throws UnitNotInPackagingQuantitiesException {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (targetUnit == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null IQuantity");
        }
        if (packagingQuantities == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        return UnitCalculator.isUnitInArticlePackingTable1(article, targetUnit, packagingQuantities);
    }

    public static boolean hasSameUnitSystem(IUnit q1, IUnit q2) {
        if (q1 == null) {
            throw new InternalServerException("Unable to check base IUnit with null IUnit");
        }
        if (q2 == null) {
            throw new InternalServerException("Unable to check base IUnit with null IUnit");
        }
        return q1.getUnitSystem().equals(q2.getUnitSystem());
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static boolean isInteger(double value) {
        return Math.abs(value - (double)Math.round(value)) < 1.0E-7;
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IQuantity normalizeQuantity(IStoreQuantity quantity) {
        return UnitCalculator.normalizeQuantity(UnitCalculator.convert(quantity));
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IQuantity normalizeQuantity(IQuantity quantity) {
        if (quantity == null || quantity.getUnit() == null || quantity.getAmount() == null) {
            throw new InternalServerException("Unable normalize null IQuantity");
        }
        return UnitCalculator.normalizeQuantity1(quantity);
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IStoreQuantity min(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantity, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (q1 == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null IQuantity");
        }
        if (q1PackagingQuantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        if (q2 == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null IQuantity");
        }
        if (q2PackagingQuantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        return UnitCalculator.min1(article, q1, q1PackagingQuantity, q2, q2PackagingQuantity);
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IStoreQuantity max(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantity, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (q1 == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null IQuantity");
        }
        if (q1PackagingQuantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        if (q2 == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null IQuantity");
        }
        if (q2PackagingQuantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        return UnitCalculator.max1(article, q1, q1PackagingQuantity, q2, q2PackagingQuantity);
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IStoreQuantity neg(IStoreQuantity q) {
        if (q == null) {
            return null;
        }
        return q.newStoreQuantity(-q.getAmount().longValue(), q.getUnit());
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static IQuantity neg(IQuantity q) {
        if (q == null) {
            return null;
        }
        return q.newQuantity(-q.getAmount().doubleValue(), q.getUnit());
    }

    public static IQuantity subtractQuantity(IArticleCharge charge, IBasicArticle article, IQuantity firstQuantity, IQuantity chargeQuantity, Timestamp timestamp) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to subtract quantities when charge is null");
        }
        List<? extends IPackagingQuantity> articlePackagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, timestamp);
        return UnitCalculator.subtractQuantity(charge, article, firstQuantity, chargeQuantity, articlePackagingQuantities);
    }

    public static IQuantity subtractQuantity(IArticleCharge charge, IBasicArticle article, IQuantity firstQuantity, IQuantity chargeQuantity, List<? extends IPackagingQuantity> articlePackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to subtract quantities when charge is null");
        }
        if (articlePackagingQuantities == null) {
            throw new InternalServerException("Unable to add quantities when conversion list is null");
        }
        if (firstQuantity == null) {
            firstQuantity = chargeQuantity.newQuantity(0L, article.getBaseUnit());
        }
        double fistInBaseUnit = UnitCalculator.convert(article, firstQuantity, articlePackagingQuantities, article.getBaseUnit(), articlePackagingQuantities);
        IQuantity firstQty = chargeQuantity.newQuantity(fistInBaseUnit, article.getBaseUnit());
        IQuantity t = UnitCalculator.subtractQuantities(article, firstQty, UnitCalculator.getChargePackagingQuantities(charge), chargeQuantity, UnitCalculator.getChargePackagingQuantities(charge));
        return t;
    }

    public static IStoreQuantity subtractQuantity(IArticleCharge charge, IBasicArticle article, IStoreQuantity firstQuantity, IStoreQuantity chargeQuantity, Timestamp timestamp) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to subtract quantities when charge is null");
        }
        List<? extends IPackagingQuantity> articlePackagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, timestamp);
        return UnitCalculator.subtractQuantity(charge, article, firstQuantity, chargeQuantity, articlePackagingQuantities);
    }

    public static IStoreQuantity subtractQuantity(IArticleCharge charge, IBasicArticle article, IStoreQuantity firstQuantity, IStoreQuantity chargeQuantity, List<? extends IPackagingQuantity> articlePackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to subtract quantities when charge is null");
        }
        if (articlePackagingQuantities == null) {
            throw new InternalServerException("Unable to add quantities when conversion list is null");
        }
        if (firstQuantity == null) {
            firstQuantity = chargeQuantity.newStoreQuantity(0L, article.getBaseUnit());
        }
        double fistInBaseUnit = UnitCalculator.convert(article, firstQuantity, articlePackagingQuantities, article.getBaseUnit(), articlePackagingQuantities);
        IQuantity firstQty = chargeQuantity.newQuantity(fistInBaseUnit, article.getBaseUnit());
        IQuantity chargeQty = UnitCalculator.convert(chargeQuantity);
        IQuantity t = UnitCalculator.subtractQuantitiesNormal(article, firstQty, UnitCalculator.getChargePackagingQuantities(charge), chargeQty, UnitCalculator.getChargePackagingQuantities(charge));
        return UnitCalculator.convert(article, articlePackagingQuantities, t);
    }

    public static <T> T subtractQuantitiesNormal(IArticleCharge charge, T q1, List<? extends IPackagingQuantity> q1PackagingQuantity, T q2, List<? extends IPackagingQuantity> q2PackagingQuantity) throws ValidationException {
        if (charge == null) {
            throw new InternalServerException("Unable to subtract quantities when charge is null");
        }
        if (q1PackagingQuantity == null) {
            throw new InternalServerException("Unable to add quantities when conversion list is null");
        }
        if (q2PackagingQuantity == null) {
            throw new InternalServerException("Unable to add quantities when conversion list is null");
        }
        IBasicArticle article = charge.getBasicArticle();
        return UnitCalculator.subtractQuantitiesNormal(article, q1, q1PackagingQuantity, q2, q2PackagingQuantity);
    }

    public static IStoreQuantity subtractQuantitiesNormal(IBasicArticle article, IStoreQuantity amount, IStoreQuantity amount2, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        List<? extends IPackagingQuantity> articlePackagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, validityDate);
        return UnitCalculator.subtractQuantitiesNormal(article, amount, articlePackagingQuantities, amount2, articlePackagingQuantities);
    }

    public static IQuantity subtractQuantitiesNormal(IBasicArticle article, IQuantity amount, IQuantity amount2, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to subtract quantities when article is null");
        }
        List<? extends IPackagingQuantity> articlePackagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, validityDate);
        return UnitCalculator.subtractQuantitiesNormal(article, amount, articlePackagingQuantities, amount2, articlePackagingQuantities);
    }

    public static <T> T subtractQuantitiesNormal(IBasicArticle article, T q1, List<? extends IPackagingQuantity> q1PackagingQuantity, T q2, List<? extends IPackagingQuantity> q2PackagingQuantity) throws ValidationException {
        Class<?> type;
        Class<?> c2;
        Class<?> c1 = q1 != null ? q1.getClass() : null;
        Class<?> clazz = c2 = q2 != null ? q2.getClass() : c1;
        if (c1 != null && !c1.equals(c2)) {
            throw new InternalServerException("Quantities don't have the same type (type1: " + q1.getClass().getSimpleName() + ", type2: " + q2.getClass().getSimpleName() + "!");
        }
        Class<?> clazz2 = type = c1 != null ? c1 : c2;
        if (type == null) {
            return null;
        }
        if (IStoreQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.subtractStoreQuantities(article, (IStoreQuantity)q1, q1PackagingQuantity, (IStoreQuantity)q2, q2PackagingQuantity);
        }
        if (IQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.subtractQuantities(article, (IQuantity)q1, q1PackagingQuantity, (IQuantity)q2, q2PackagingQuantity);
        }
        throw new InternalServerException("Invalid IQuantity type: " + q1.getClass().getSimpleName() + "!");
    }

    public static IStoreQuantity subtractStoreQuantities(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantities, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantities) throws ValidationException {
        if (q2 == null) {
            q2 = q1.newStoreQuantity(0L, article.getBaseUnit());
        }
        return UnitCalculator.addQuantitiesNormal(article, q1, q1PackagingQuantities, UnitCalculator.neg(q2), q2PackagingQuantities);
    }

    public static IQuantity subtractQuantities(IBasicArticle article, IQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantities, IQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantities) throws ValidationException {
        if (q2 == null) {
            q2 = q1.newQuantity(0L, article.getBaseUnit());
        }
        return UnitCalculator.addQuantitiesNormal(article, q1, q1PackagingQuantities, UnitCalculator.neg(q2), q2PackagingQuantities);
    }

    public static List<? extends IPackagingQuantity> getArticlePackagingQuantities(IBasicArticle article, Date validityDate) {
        return UnitCalculator.getArticlePackagingQuantities(article, new Timestamp(validityDate.getTime()));
    }

    public static List<? extends IPackagingQuantity> getArticlePackagingQuantities(IBasicArticle article, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to get conversion list when article is null");
        }
        return UnitCalculator.getArticlePackagingQuantities1(article, validityDate);
    }

    public static List<? extends IPackagingQuantity> getChargePackagingQuantities(IArticleCharge charge) {
        if (charge == null) {
            throw new InternalServerException("Unable to convert to get conversion list when charge is null");
        }
        return UnitCalculator.getChargePackagingQuantities1(charge);
    }

    public static List<? extends IPackagingQuantity> getChargePackagingQuantities(IArticleCharge charge, IBasicArticle article, Timestamp validity) {
        if (charge == null && article == null) {
            throw new InternalServerException("Unable to convert to get conversion list when charge and article is null");
        }
        if (charge != null) {
            return UnitCalculator.getChargePackagingQuantities1(charge);
        }
        return UnitCalculator.getArticlePackagingQuantities1(article, validity);
    }

    public static List<? extends IPackagingQuantity> getSupplierConditionPackagingQuantities(IBasicArticle article, ISupplierCondition condition, Timestamp validity) {
        if (condition == null && article == null) {
            throw new InternalServerException("Unable to convert to get conversion list when supplier conditiSon and article is null");
        }
        if (condition != null && Boolean.TRUE.equals(condition.getUsePackingQuantity()) && condition.getConversion() != null) {
            return UnitCalculator.getConditionPackagingQuantities(condition);
        }
        return UnitCalculator.getArticlePackagingQuantities(article, validity);
    }

    public static List<? extends IPackagingQuantity> getPositionOrderPosPackagingQuantities(IPurchaseOrderPosition pop) {
        if (pop == null) {
            throw new InternalServerException("Unable to convert to get conversion list when order position is null");
        }
        return UnitCalculator.getSupplierConditionPackagingQuantities(pop.getArticle(), pop.getSupplierCondition(), new Timestamp(pop.getPurchaseOrder().getOrderDate().getTime()));
    }

    public static double getConversionFactorForRecipe(IRecipeVariant recipe, IUnit sourceUnit, IUnit targetUnit) {
        UnitCalculator.ensureParametersRecipe(recipe, sourceUnit, targetUnit);
        if (sourceUnit.equals(targetUnit)) {
            return 1.0;
        }
        if (UnitCalculator.isConvertible(sourceUnit, targetUnit)) {
            return UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, targetUnit);
        }
        throw new InternalServerException("Unable to calculate Recipe " + recipe.getRecipeBase().getNumber() + " - " + recipe.getName() + " from " + sourceUnit.getShortName() + " to " + targetUnit.getShortName());
    }

    public static double getConversionFactorForArticle(IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        UnitCalculator.ensureParametersArticle(article, sourceUnit, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        return UnitCalculator.getConversionFactor1(article, sourceUnit, sourcePackagingQuantities, targetUnit, targetPackagingQuantities, true);
    }

    public static boolean isConvertible(IUnit u1, IUnit u2) {
        IUnitSystem unitSystem1 = u1.getUnitSystem();
        IUnitSystem unitSystem2 = u2.getUnitSystem();
        return Objects.equals(unitSystem1, unitSystem2);
    }

    public static boolean isConvertible(IBasicArticle article1, IBasicArticle article2, Timestamp validity) {
        List<? extends IPackagingQuantity> article1Conversion = UnitCalculator.getArticlePackagingQuantities(article1, validity);
        List<? extends IPackagingQuantity> article2Conversion = UnitCalculator.getArticlePackagingQuantities(article2, validity);
        return UnitCalculator.isConvertible(article1, article1Conversion, article2, article2Conversion);
    }

    @PegasusTested(testClass="QUnitCalculator_convertTest")
    public static boolean isConvertible(IBasicArticle article1, List<? extends IPackagingQuantity> article1Conversion, IBasicArticle article2, List<? extends IPackagingQuantity> article2Conversion) {
        HashSet<IUnitSystem> article1Units = new HashSet<IUnitSystem>();
        HashSet<IUnitSystem> article2Units = new HashSet<IUnitSystem>();
        for (IPackagingQuantity iPackagingQuantity : article1Conversion) {
            article1Units.add(iPackagingQuantity.getUnit().getUnitSystem());
        }
        for (IPackagingQuantity iPackagingQuantity : article2Conversion) {
            article2Units.add(iPackagingQuantity.getUnit().getUnitSystem());
        }
        article1Units.retainAll(article2Units);
        return !article1Units.isEmpty();
    }

    public static boolean isConvertible(IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        UnitCalculator.ensureParametersArticle(article, sourceUnit, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        Double conversionFactor = UnitCalculator.getConversionFactor1(article, sourceUnit, sourcePackagingQuantities, targetUnit, targetPackagingQuantities, false);
        return conversionFactor != null;
    }

    public static double convert(IBasicArticle article, IStoreQuantity quantity, IUnit targetUnit, List<? extends IPackagingQuantity> conversionTable) {
        if (article == null) {
            throw new InternalServerException("Unable to convert quantity with null Article");
        }
        return UnitCalculator.convert(article, quantity, conversionTable, targetUnit, conversionTable);
    }

    public static double convert(IBasicArticle article, IStoreQuantity quantity, IUnit targetUnit, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to convert quantity with null Article");
        }
        IPackagingQuantityBase packingQuantitiesVariant = article.getPackingQuantitiesVariant(validityDate);
        return UnitCalculator.convert(article, quantity, packingQuantitiesVariant.getConversion(), targetUnit, packingQuantitiesVariant.getConversion());
    }

    public static double convert(IBasicArticle article1, IBasicArticle article2, IQuantity quantity, IUnit targetUnit, Timestamp validityDate) {
        if (article1 == null || article2 == null) {
            throw new InternalServerException("Unable to convert quantity with null Article");
        }
        IPackagingQuantityBase packingQuantitiesVariant_1 = article1.getPackingQuantitiesVariant(validityDate);
        IPackagingQuantityBase packingQuantitiesVariant_2 = article2.getPackingQuantitiesVariant(validityDate);
        UnitCalculator.ensureParametersArticle(article1, quantity, packingQuantitiesVariant_1.getConversion(), targetUnit, packingQuantitiesVariant_2.getConversion());
        return UnitCalculator.convert2(article1, quantity, packingQuantitiesVariant_1.getConversion(), targetUnit, packingQuantitiesVariant_2.getConversion());
    }

    public static double convert(IBasicArticle article1, IBasicArticle article2, IStoreQuantity quantity, IUnit targetUnit, Timestamp validityDate) {
        if (article1 == null || article2 == null) {
            throw new InternalServerException("Unable to convert quantity with null Article");
        }
        IPackagingQuantityBase packingQuantitiesVariant_1 = article1.getPackingQuantitiesVariant(validityDate);
        IPackagingQuantityBase packingQuantitiesVariant_2 = article2.getPackingQuantitiesVariant(validityDate);
        UnitCalculator.ensureParametersArticle(article1, quantity, packingQuantitiesVariant_1.getConversion(), targetUnit, packingQuantitiesVariant_2.getConversion());
        return UnitCalculator.convert2(article1, UnitCalculator.convert(quantity), packingQuantitiesVariant_1.getConversion(), targetUnit, packingQuantitiesVariant_2.getConversion());
    }

    public static double convert(IBasicArticle article, IQuantity quantity, IUnit targetUnit, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to convert quantity with null Article");
        }
        IPackagingQuantityBase packingQuantitiesVariant = article.getPackingQuantitiesVariant(validityDate);
        return UnitCalculator.convert(article, quantity, packingQuantitiesVariant.getConversion(), targetUnit, packingQuantitiesVariant.getConversion());
    }

    public static double convert(IBasicArticle article, IStoreQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        return UnitCalculator.convert(article, UnitCalculator.convert(quantity), sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
    }

    public static double convert(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        UnitCalculator.ensureParametersArticle(article, quantity, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        return UnitCalculator.convert1(article, quantity, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
    }

    public static IQuantity convertToBaseUnit(IArticleCharge charge, IStoreQuantity quantity) {
        return UnitCalculator.convertToBaseUnit(charge, UnitCalculator.convert(quantity));
    }

    public static IQuantity convertToBaseUnit(IArticleCharge charge, IQuantity quantity) {
        if (charge == null) {
            throw new InternalServerException("Unable to convert to base IUnit when charge is null");
        }
        if (quantity == null) {
            throw new InternalServerException("Unable to convert charge " + charge.getNumber() + " (Article " + charge.getBasicArticle().getNumber() + " - " + charge.getBasicArticle().getName() + ") with null IQuantity");
        }
        IBasicArticle article = charge.getBasicArticle();
        List<? extends IPackagingQuantity> packagingQuantities = UnitCalculator.getChargePackagingQuantities(charge);
        if (UnitCalculator.isConvertible(article, quantity.getUnit(), packagingQuantities, article.getBaseUnit(), packagingQuantities)) {
            return UnitCalculator.convertToBaseUnit1(article, quantity, packagingQuantities, packagingQuantities);
        }
        throw new InternalServerException("Unit " + quantity.getUnit().getShortName() + " is not defined in Charge's (" + charge.getNumber() + ") Conversion Table");
    }

    public static IQuantity convertToBaseUnit(IBasicArticle article, IQuantity quantity, Date validityDate) {
        return UnitCalculator.convertToBaseUnit(article, quantity, new Timestamp(validityDate.getTime()));
    }

    public static IQuantity convertToBaseUnit(IBasicArticle article, IQuantity quantity, Timestamp validityDate) {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (quantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null quantity");
        }
        List<? extends IPackagingQuantity> packagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, validityDate);
        if (UnitCalculator.isConvertible(article, quantity.getUnit(), packagingQuantities, article.getBaseUnit(), packagingQuantities)) {
            return UnitCalculator.convertToBaseUnit1(article, quantity, packagingQuantities, packagingQuantities);
        }
        throw new InternalServerException("Unit " + quantity.getUnit().getShortName() + " is not defined in Article's (" + article.getNumber() + ") Conversion Table");
    }

    public static double getConversionFactorForRecipe(IQuantity quantity, IUnit targetUnit) {
        if (quantity == null) {
            throw new InternalServerException("Quantity can not be null");
        }
        if (quantity.getUnit() == null) {
            throw new InternalServerException("Quantity IUnit can not be null");
        }
        if (targetUnit == null) {
            throw new InternalServerException("Target IUnit can not be null");
        }
        Double conversionFactor = UnitCalculator.getConversionFactorForUnitSystem(quantity.getUnit(), targetUnit);
        return quantity.getAmount().equals(0.0) ? 0.0 : quantity.getAmount() * conversionFactor;
    }

    public static IQuantity convertToTargetUnitWhenPossibleElseToBaseUnit(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        UnitCalculator.ensureParametersArticle(article, quantity, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        if (UnitCalculator.isConvertible(article, quantity.getUnit(), sourcePackagingQuantities, targetUnit, targetPackagingQuantities)) {
            Double conversionFactor = UnitCalculator.getConversionFactor1(article, quantity.getUnit(), sourcePackagingQuantities, targetUnit, targetPackagingQuantities, true);
            if (conversionFactor == null) {
                return quantity;
            }
            IQuantity iQuantity = quantity.newQuantity(UnitCalculator.multiply(quantity, conversionFactor), targetUnit);
            return iQuantity;
        }
        Double conversionFactor = UnitCalculator.getConversionFactor1(article, quantity.getUnit(), sourcePackagingQuantities, article.getBaseUnit(), targetPackagingQuantities, true);
        if (conversionFactor == null) {
            return quantity;
        }
        IQuantity iQuantity = quantity.newQuantity(UnitCalculator.multiply(quantity, conversionFactor), article.getBaseUnit());
        return iQuantity;
    }

    private static double multiply(IQuantity quantity, Double conversionFactor) {
        BigDecimal f = BigDecimal.valueOf(conversionFactor);
        BigDecimal i = BigDecimal.valueOf(quantity.getAmount());
        return f.multiply(i).setScale(10, RoundingMode.CEILING).doubleValue();
    }

    public static IQuantity convertToTargetUnitWhenPossibleElseToBaseUnit(IBasicArticle article, IStoreQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        return UnitCalculator.convertToTargetUnitWhenPossibleElseToBaseUnit(article, UnitCalculator.convert(quantity), sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
    }

    public static IQuantity convert(IStoreQuantity quantity) {
        if (quantity == null || quantity.getAmount() == null || quantity.getUnit() == null) {
            throw new InternalServerException("Unable to convert null IQuantity");
        }
        return quantity.newQuantity(quantity.getAmount().doubleValue(), quantity.getUnit());
    }

    public static IStoreQuantity convertToPieceUnit(IBasicArticle article, List<? extends IPackagingQuantity> packingList, IStoreQuantity quantity) {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (quantity == null) {
            throw new InternalServerException("Unable to convert null IQuantity");
        }
        if (packingList == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        IUnit sourceUnit = quantity.getUnit();
        IUnit targetUnit = article.getBaseUnit();
        if (targetUnit.equals(sourceUnit)) {
            return quantity;
        }
        if (!UnitCalculator.isConvertible(article, sourceUnit, packingList, targetUnit, packingList)) {
            throw new UnitNotInPackagingQuantitiesException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + " from " + sourceUnit.getShortName() + " to " + targetUnit.getShortName());
        }
        double quantityInBase = UnitCalculator.convert(article, quantity, targetUnit, packingList);
        if (UnitCalculator.isInteger(quantityInBase)) {
            return quantity.newStoreQuantity(Math.round(quantityInBase), targetUnit);
        }
        return quantity.newStoreQuantity((int)Math.ceil(quantityInBase), targetUnit);
    }

    public static IStoreQuantity convert(IBasicArticle article, List<? extends IPackagingQuantity> packingList, IQuantity quantity) {
        if (article == null) {
            throw new InternalServerException("Unable to convert to base IUnit when article is null");
        }
        if (quantity == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null quantity");
        }
        if (packingList == null) {
            throw new InternalServerException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + ") with null conversion list");
        }
        return UnitCalculator.convertToStoreQuantity1(article, packingList, quantity);
    }

    public static IStoreQuantity convertToStoreQuantity(IBasicArticle article, IStoreQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        UnitCalculator.ensureParametersArticle(article, quantity, sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        double amount = UnitCalculator.convert1(article, UnitCalculator.convert(quantity), sourcePackagingQuantities, targetUnit, targetPackagingQuantities);
        IStoreQuantity newQuantity = UnitCalculator.convertToStoreQuantity1(article, targetPackagingQuantities, quantity.newQuantity(amount, targetUnit));
        return newQuantity;
    }

    public static IStoreQuantity addQuantity(IArticleCharge charge, IBasicArticle article, IStoreQuantity firstQuantity, IStoreQuantity chargeQuantity, Timestamp timestamp) {
        if (article == null) {
            throw new InternalServerException("Unable to add quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to add quantities when charge is null");
        }
        List<? extends IPackagingQuantity> articlePackagingQuantities = UnitCalculator.getArticlePackagingQuantities(article, timestamp);
        return UnitCalculator.addQuantity(charge, article, firstQuantity, chargeQuantity, articlePackagingQuantities);
    }

    public static IQuantity addQuantity(IArticleCharge charge, IBasicArticle article, IQuantity firstQuantity, IQuantity chargeQuantity, List<? extends IPackagingQuantity> articlePackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Unable to add quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to add quantities when charge is null");
        }
        if (firstQuantity == null) {
            firstQuantity = chargeQuantity.newQuantity(0L, article.getBaseUnit());
        }
        double fistInBaseUnit = UnitCalculator.convert(article, firstQuantity, articlePackagingQuantities, article.getBaseUnit(), articlePackagingQuantities);
        IQuantity firstQty = chargeQuantity.newQuantity(fistInBaseUnit, article.getBaseUnit());
        IQuantity t = UnitCalculator.addQuantitiesCharge(article, firstQty, chargeQuantity, UnitCalculator.getChargePackagingQuantities(charge));
        return t;
    }

    public static IStoreQuantity addQuantity(IArticleCharge charge, IBasicArticle article, IStoreQuantity firstQuantity, IStoreQuantity chargeQuantity, List<? extends IPackagingQuantity> articlePackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Unable to add quantities when article is null");
        }
        if (charge == null) {
            throw new InternalServerException("Unable to add quantities when charge is null");
        }
        if (articlePackagingQuantities == null) {
            throw new InternalServerException("Unable to add quantities when conversion list is null");
        }
        if (firstQuantity == null) {
            firstQuantity = chargeQuantity.newStoreQuantity(0L, article.getBaseUnit());
        }
        if (firstQuantity.getUnit().equals(chargeQuantity.getUnit())) {
            return chargeQuantity.newStoreQuantity(firstQuantity.getAmount() + chargeQuantity.getAmount(), firstQuantity.getUnit());
        }
        double fistInBaseUnit = UnitCalculator.convert(article, firstQuantity, articlePackagingQuantities, article.getBaseUnit(), articlePackagingQuantities);
        IQuantity firstQty = chargeQuantity.newQuantity(fistInBaseUnit, article.getBaseUnit());
        IQuantity chargeQty = UnitCalculator.convert(chargeQuantity);
        List<? extends IPackagingQuantity> chargePackagingQuantities = UnitCalculator.getChargePackagingQuantities(charge);
        IQuantity t = UnitCalculator.addQuantitiesCharge(article, firstQty, chargeQty, chargePackagingQuantities);
        return UnitCalculator.convert(article, articlePackagingQuantities, t);
    }

    public static <T> T addQuantitiesCharge(IBasicArticle article, T q1, T q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        Class<?> type;
        Class<?> c2;
        if (article == null) {
            throw new InternalServerException("Unable to add quantities when article is null");
        }
        Class<?> c1 = q1 != null ? q1.getClass() : null;
        Class<?> clazz = c2 = q2 != null ? q2.getClass() : null;
        if (c1 != null && c2 != null && !c1.equals(c2)) {
            throw new InternalServerException("Quantities don't have the same type (type1: " + q1.getClass().getSimpleName() + ", type2: " + q2.getClass().getSimpleName() + "!");
        }
        Class<?> clazz2 = type = c1 != null ? c1 : c2;
        if (type == null) {
            return null;
        }
        if (IStoreQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.addQuantitiesNormal(article, (IStoreQuantity)q1, q2PackagingQuantity, (IStoreQuantity)q2, q2PackagingQuantity);
        }
        if (IQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.addQuantitiesNormal(article, (IQuantity)q1, q2PackagingQuantity, (IQuantity)q2, q2PackagingQuantity);
        }
        throw new InternalServerException("Invalid IQuantity type: " + q1.getClass().getSimpleName() + "!");
    }

    public static <T> T addQuantitiesNormal(IBasicArticle article, T q1, T q2, Timestamp validityDate) {
        return UnitCalculator.addQuantitiesNormal(article, q1, UnitCalculator.getArticlePackagingQuantities(article, validityDate), q2, UnitCalculator.getArticlePackagingQuantities(article, validityDate));
    }

    @PegasusTested(testClass="QuantityCalculatorCalculateTest")
    public static <T> T addQuantitiesNormal(IBasicArticle article, T q1, List<? extends IPackagingQuantity> q1PackagingQuantity, T q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        Class<?> type;
        Class<?> c2;
        if (article == null) {
            throw new InternalServerException("Unable to add quantities when article is null");
        }
        Class<?> c1 = q1 != null ? q1.getClass() : null;
        Class<?> clazz = c2 = q2 != null ? q2.getClass() : null;
        if (c1 != null && c2 != null && !c1.equals(c2)) {
            throw new InternalServerException("Quantities don't have the same type (type1: " + q1.getClass().getSimpleName() + ", type2: " + q2.getClass().getSimpleName() + "!");
        }
        Class<?> clazz2 = type = c1 != null ? c1 : c2;
        if (type == null) {
            return null;
        }
        if (IStoreQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.addQuantitiesNormal(article, (IStoreQuantity)q1, q1PackagingQuantity, (IStoreQuantity)q2, q2PackagingQuantity);
        }
        if (IQuantity.class.isAssignableFrom(type)) {
            return (T)UnitCalculator.addQuantitiesNormal(article, (IQuantity)q1, q1PackagingQuantity, (IQuantity)q2, q2PackagingQuantity);
        }
        throw new InternalServerException("Invalid IQuantity type: " + q1.getClass().getSimpleName() + "!");
    }

    private static IQuantity addQuantitiesNormal(IBasicArticle article, IQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantities, IQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantities) throws ValidationException {
        if (q1 == null || q1.getAmount() == null || q1.getUnit() == null) {
            if (q2 != null) {
                return q2.newQuantity(q2.getAmount(), q2.getUnit());
            }
            return null;
        }
        if (q2 == null || q2.getAmount() == null || q2.getUnit() == null) {
            if (q1 != null) {
                return q1.newQuantity(q1.getAmount(), q1.getUnit());
            }
            return null;
        }
        IUnit baseUnit = article.getBaseUnit();
        double amount1 = UnitCalculator.convert(article, q1, q1PackagingQuantities, baseUnit, q1PackagingQuantities);
        double amount2 = UnitCalculator.convert(article, q2, q2PackagingQuantities, baseUnit, q2PackagingQuantities);
        return q1.newQuantity(amount1 + amount2, baseUnit);
    }

    private static IStoreQuantity addQuantitiesNormal(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantities, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantities) throws ValidationException {
        if (q1 == null || q1.getAmount() == null || q1.getUnit() == null) {
            if (q2 != null) {
                return q2.newStoreQuantity(q2.getAmount(), q2.getUnit());
            }
            return null;
        }
        if (q2 == null || q2.getAmount() == null || q2.getUnit() == null) {
            if (q1 != null) {
                return q1.newStoreQuantity(q1.getAmount(), q1.getUnit());
            }
            return null;
        }
        ArrayList<IUnit> pqUnits = new ArrayList<IUnit>();
        if (article != null) {
            if (q1PackagingQuantities != null) {
                for (IPackagingQuantity iPackagingQuantity : q1PackagingQuantities) {
                    pqUnits.add(iPackagingQuantity.getUnit());
                }
            }
            if (q2PackagingQuantities != null) {
                for (IPackagingQuantity iPackagingQuantity : q2PackagingQuantities) {
                    pqUnits.add(iPackagingQuantity.getUnit());
                }
            }
        }
        IUnit baseUnit = article.getBaseUnit();
        pqUnits.remove(baseUnit);
        double d = UnitCalculator.convert(article, q1, q1PackagingQuantities, baseUnit, q1PackagingQuantities);
        double amount2 = UnitCalculator.convert(article, q2, q2PackagingQuantities, baseUnit, q2PackagingQuantities);
        double highestAmount1 = 0.0;
        IUnit smallestUnit = baseUnit;
        while (!UnitCalculator.isInteger(d) || !UnitCalculator.isInteger(amount2)) {
            if ((baseUnit = baseUnit.getSubUnit()) != null) {
                d *= (double)baseUnit.getConversionFactor().intValue();
                amount2 *= (double)baseUnit.getConversionFactor().intValue();
            } else if (!pqUnits.isEmpty()) {
                int i = pqUnits.size() - 1;
                baseUnit = (IUnit)pqUnits.get(i);
                while (baseUnit.getSuperUnit() != null) {
                    baseUnit = baseUnit.getSuperUnit();
                }
                pqUnits.remove(i);
                d = UnitCalculator.convert(article, q1, q1PackagingQuantities, baseUnit, q1PackagingQuantities);
                amount2 = UnitCalculator.convert(article, q2, q2PackagingQuantities, baseUnit, q2PackagingQuantities);
            } else {
                baseUnit = smallestUnit;
                d = UnitCalculator.convert(article, q1, q1PackagingQuantities, baseUnit, q1PackagingQuantities);
                amount2 = UnitCalculator.convert(article, q2, q2PackagingQuantities, baseUnit, q2PackagingQuantities);
                break;
            }
            if (!(d > highestAmount1)) continue;
            highestAmount1 = d;
            smallestUnit = baseUnit;
        }
        return q1.newStoreQuantity(Math.round(d + amount2), baseUnit);
    }

    private static Double getConversionFactor1(IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities, boolean strict) {
        Collections.sort(sourcePackagingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        Collections.sort(targetPackagingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        if (sourceUnit.equals(targetUnit)) {
            return 1.0;
        }
        if (UnitCalculator.isConvertible(sourceUnit, targetUnit)) {
            return UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, targetUnit);
        }
        IUnit baseUnit = article.getBaseUnit();
        Double sourceFactor = UnitCalculator.isConvertible(sourceUnit, baseUnit) ? UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, baseUnit) : UnitCalculator.getConversionFactorForConversionTable(article, sourceUnit, baseUnit, sourcePackagingQuantities, strict);
        Double targetFactor = UnitCalculator.isConvertible(baseUnit, targetUnit) ? UnitCalculator.getConversionFactorForUnitSystem(baseUnit, targetUnit) : UnitCalculator.getConversionFactorForConversionTable(article, baseUnit, targetUnit, targetPackagingQuantities, strict);
        if (sourceFactor == null || targetFactor == null) {
            baseUnit = targetUnit;
            sourceFactor = UnitCalculator.isConvertible(sourceUnit, baseUnit) ? UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, baseUnit) : UnitCalculator.getConversionFactorForConversionTable(article, sourceUnit, baseUnit, sourcePackagingQuantities, strict);
            targetFactor = UnitCalculator.isConvertible(baseUnit, targetUnit) ? UnitCalculator.getConversionFactorForUnitSystem(baseUnit, targetUnit) : UnitCalculator.getConversionFactorForConversionTable(article, baseUnit, targetUnit, targetPackagingQuantities, strict);
            if (sourceFactor == null || targetFactor == null) {
                baseUnit = sourceUnit;
                sourceFactor = UnitCalculator.isConvertible(sourceUnit, baseUnit) ? UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, baseUnit) : UnitCalculator.getConversionFactorForConversionTable(article, sourceUnit, baseUnit, sourcePackagingQuantities, strict);
                targetFactor = UnitCalculator.isConvertible(baseUnit, targetUnit) ? UnitCalculator.getConversionFactorForUnitSystem(baseUnit, targetUnit) : UnitCalculator.getConversionFactorForConversionTable(article, baseUnit, targetUnit, targetPackagingQuantities, strict);
                if (sourceFactor == null || targetFactor == null) {
                    return null;
                }
            }
        }
        return sourceFactor * targetFactor;
    }

    private static Double getConversionFactorWithAllUnits(IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities, boolean strict) {
        IUnit selectUnit;
        Collections.sort(sourcePackagingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        Collections.sort(targetPackagingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        if (sourceUnit.equals(targetUnit)) {
            return 1.0;
        }
        if (UnitCalculator.isConvertible(sourceUnit, targetUnit)) {
            return UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, targetUnit);
        }
        ArrayList<IUnit> baseUnitList = new ArrayList<IUnit>();
        baseUnitList.add(article.getBaseUnit());
        baseUnitList.add(targetUnit);
        baseUnitList.add(sourceUnit);
        for (IPackagingQuantity iterator : sourcePackagingQuantities) {
            baseUnitList.add(iterator.getUnit());
        }
        Double factor = null;
        Iterator iterator = baseUnitList.iterator();
        while (iterator.hasNext() && (factor = UnitCalculator.getConversionFactorFor(selectUnit = (IUnit)iterator.next(), article, sourceUnit, sourcePackagingQuantities, targetUnit, targetPackagingQuantities, strict)) == null) {
        }
        return factor;
    }

    private static Double getConversionFactorFor(IUnit selectUnit, IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities, boolean strict) {
        Double sourceFactor = null;
        Double targetFactor = null;
        sourceFactor = UnitCalculator.isConvertible(sourceUnit, selectUnit) ? UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, selectUnit) : UnitCalculator.getConversionFactorForConversionTable(article, sourceUnit, selectUnit, sourcePackagingQuantities, strict);
        targetFactor = UnitCalculator.isConvertible(selectUnit, targetUnit) ? UnitCalculator.getConversionFactorForUnitSystem(selectUnit, targetUnit) : UnitCalculator.getConversionFactorForConversionTable(article, selectUnit, targetUnit, targetPackagingQuantities, strict);
        if (sourceFactor == null || targetFactor == null) {
            return null;
        }
        return sourceFactor * targetFactor;
    }

    private static Double getConversionFactorForConversionTable(IBasicArticle article, IUnit sourceUnit, IUnit targetUnit, List<? extends IPackagingQuantity> conversion, boolean strict) {
        int indexOfSource = -1;
        int indexOfTarget = -1;
        for (IPackagingQuantity iPackagingQuantity : conversion) {
            if (UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), sourceUnit)) {
                indexOfSource = iPackagingQuantity.getSequenceNumber();
            }
            if (!UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), targetUnit)) continue;
            indexOfTarget = iPackagingQuantity.getSequenceNumber();
        }
        double factor = 1.0;
        if (indexOfSource < indexOfTarget) {
            boolean foundStart = false;
            boolean foundEnd = false;
            for (IPackagingQuantity iPackagingQuantity : conversion) {
                Double iUnitSystemFactor;
                if (foundStart && !foundEnd) {
                    factor *= (double)iPackagingQuantity.getAmount().intValue();
                }
                if (UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), sourceUnit)) {
                    iUnitSystemFactor = UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, iPackagingQuantity.getUnit());
                    factor *= iUnitSystemFactor.doubleValue();
                    foundStart = true;
                }
                if (!UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), targetUnit)) continue;
                iUnitSystemFactor = UnitCalculator.getConversionFactorForUnitSystem(targetUnit, iPackagingQuantity.getUnit());
                factor /= iUnitSystemFactor.doubleValue();
                foundEnd = true;
            }
            if (!foundStart || !foundEnd) {
                if (strict) {
                    throw new UnitNotInPackagingQuantitiesException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + " from " + sourceUnit.getShortName() + " to " + targetUnit.getShortName());
                }
                return null;
            }
        } else {
            boolean foundStart = false;
            boolean foundEnd = false;
            for (IPackagingQuantity iPackagingQuantity : conversion) {
                Double iUnitSystemFactor;
                if (foundStart && !foundEnd) {
                    factor /= (double)iPackagingQuantity.getAmount().intValue();
                }
                if (UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), targetUnit)) {
                    iUnitSystemFactor = UnitCalculator.getConversionFactorForUnitSystem(targetUnit, iPackagingQuantity.getUnit());
                    factor /= iUnitSystemFactor.doubleValue();
                    foundStart = true;
                }
                if (!UnitCalculator.isConvertible(iPackagingQuantity.getUnit(), sourceUnit)) continue;
                iUnitSystemFactor = UnitCalculator.getConversionFactorForUnitSystem(sourceUnit, iPackagingQuantity.getUnit());
                factor *= iUnitSystemFactor.doubleValue();
                foundEnd = true;
            }
            if (!foundStart || !foundEnd) {
                if (strict) {
                    throw new UnitNotInPackagingQuantitiesException("Unable to convert Article " + article.getNumber() + " - " + article.getName() + " from " + sourceUnit.getShortName() + " to " + targetUnit.getShortName());
                }
                return null;
            }
        }
        return factor;
    }

    private static Double getConversionFactorForUnitSystem(IUnit sourceUnit, IUnit targetUnit) {
        IUnit currentUnit;
        if (Objects.equals(sourceUnit, targetUnit)) {
            return 1.0;
        }
        double factor = 1.0;
        boolean found = false;
        for (currentUnit = sourceUnit; currentUnit != null && !found; currentUnit = currentUnit.getSuperUnit()) {
            if (currentUnit.equals(targetUnit)) {
                found = true;
                continue;
            }
            if (currentUnit.getConversionFactor() == null) continue;
            factor /= (double)currentUnit.getConversionFactor().intValue();
        }
        if (found) {
            return factor;
        }
        factor = 1.0;
        for (currentUnit = sourceUnit; currentUnit != null && !found; currentUnit = currentUnit.getSubUnit()) {
            if (currentUnit.equals(targetUnit)) {
                found = true;
                continue;
            }
            if (currentUnit.getSubUnit() == null || currentUnit.getSubUnit().getConversionFactor() == null) continue;
            factor *= (double)currentUnit.getSubUnit().getConversionFactor().intValue();
        }
        return factor;
    }

    private static double convert1(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (quantity.getAmount().equals(0.0)) {
            return 0.0;
        }
        double conversionFactor = UnitCalculator.getConversionFactor1(article, quantity.getUnit(), sourcePackagingQuantities, targetUnit, targetPackagingQuantities, true);
        return quantity.getAmount() * conversionFactor;
    }

    private static double convert2(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (quantity.getAmount().equals(0.0)) {
            return 0.0;
        }
        double conversionFactor = UnitCalculator.getConversionFactorWithAllUnits(article, quantity.getUnit(), sourcePackagingQuantities, targetUnit, targetPackagingQuantities, false);
        return quantity.getAmount() * conversionFactor;
    }

    public static IQuantity convertToBaseUnit1(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackaging, List<? extends IPackagingQuantity> targetPackaging) {
        Double conversionFactor = UnitCalculator.getConversionFactor1(article, quantity.getUnit(), sourcePackaging, article.getBaseUnit(), targetPackaging, true);
        double amount = quantity.getAmount() * conversionFactor;
        return quantity.newQuantity(amount, article.getBaseUnit());
    }

    private static IStoreQuantity convertToStoreQuantity1(IBasicArticle article, List<? extends IPackagingQuantity> packingList, IQuantity quantity) {
        IUnit unit = quantity.getUnit();
        double amount = quantity.getAmount();
        if (UnitCalculator.isInteger(amount)) {
            amount -= Math.abs(amount - (double)Math.round(amount));
            return quantity.newStoreQuantity(Math.round(amount), unit);
        }
        double highestAmount = amount;
        IUnit smallestUnit = unit;
        Collections.sort(packingList, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        for (int i = 0; i < packingList.size(); ++i) {
            IPackagingQuantity pq = packingList.get(i);
            unit = pq.getUnit();
            while (unit.getSuperUnit() != null) {
                unit = unit.getSuperUnit();
            }
            amount = UnitCalculator.convert1(article, quantity, packingList, unit, packingList);
            while (!UnitCalculator.isInteger(amount) && (unit = unit.getSubUnit()) != null) {
                if (!((amount *= (double)unit.getConversionFactor().intValue()) > highestAmount)) continue;
                highestAmount = amount;
                smallestUnit = unit;
            }
            if (!UnitCalculator.isInteger(amount)) continue;
            amount -= Math.abs(amount - (double)Math.round(amount));
            return quantity.newStoreQuantity(Math.round(amount), unit);
        }
        return quantity.newStoreQuantity(Math.round(highestAmount), smallestUnit);
    }

    private static void ensureParametersArticle(IBasicArticle article, IUnit sourceUnit, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Article can not be null");
        }
        UnitCalculator.ensureParameterUnits(sourceUnit, targetUnit);
        UnitCalculator.ensureParameterConversionList(sourcePackagingQuantities, targetPackagingQuantities);
    }

    private static void ensureParametersArticle(IBasicArticle article, IQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Article can not be null");
        }
        if (quantity == null) {
            throw new InternalServerException("Quantity must be set");
        }
        UnitCalculator.ensureParameterUnits(quantity.getUnit(), targetUnit);
        UnitCalculator.ensureParameterConversionList(sourcePackagingQuantities, targetPackagingQuantities);
    }

    private static void ensureParametersArticle(IBasicArticle article, IStoreQuantity quantity, List<? extends IPackagingQuantity> sourcePackagingQuantities, IUnit targetUnit, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (article == null) {
            throw new InternalServerException("Article can not be null");
        }
        if (quantity == null) {
            throw new InternalServerException("Quantity must be set");
        }
        UnitCalculator.ensureParameterUnits(quantity.getUnit(), targetUnit);
        UnitCalculator.ensureParameterConversionList(sourcePackagingQuantities, targetPackagingQuantities);
    }

    private static void ensureParametersRecipe(IRecipeVariant recipeVariant, IUnit sourceUnit, IUnit targetUnit) {
        if (recipeVariant == null) {
            throw new InternalServerException("Recipe can not be null");
        }
        UnitCalculator.ensureParameterUnits(sourceUnit, targetUnit);
    }

    private static void ensureParameterUnits(IUnit sourceUnit, IUnit targetUnit) {
        if (sourceUnit == null && targetUnit == null) {
            throw new InternalServerException("Source IUnit and Target IUnit can not be null");
        }
        if (sourceUnit == null) {
            throw new InternalServerException("Source IUnit can not be null");
        }
        if (targetUnit == null) {
            throw new InternalServerException("Target IUnit can not be null");
        }
    }

    private static void ensureParameterConversionList(List<? extends IPackagingQuantity> sourcePackagingQuantities, List<? extends IPackagingQuantity> targetPackagingQuantities) {
        if (sourcePackagingQuantities == null) {
            throw new InternalServerException("Source Packaging Quantities can not be null");
        }
        if (targetPackagingQuantities == null) {
            throw new InternalServerException("Target Packaging Quantities can not be null");
        }
    }

    private static List<? extends IPackagingQuantity> getArticlePackagingQuantities1(IBasicArticle article, Timestamp validityDate) {
        List<? extends IPackagingQuantity> packingQuantities = article.getPackingQuantitiesVariant(validityDate).getConversion();
        Collections.sort(packingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        return packingQuantities;
    }

    private static List<? extends IPackagingQuantity> getChargePackagingQuantities1(IArticleCharge charge) {
        List<? extends IPackagingQuantity> packingQuantities = charge.getConversion();
        Collections.sort(packingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        return packingQuantities;
    }

    private static List<? extends IPackagingQuantity> getConditionPackagingQuantities(ISupplierCondition condition) {
        List<? extends IPackagingQuantity> packingQuantities = condition.getConversion();
        Collections.sort(packingQuantities, (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
        return packingQuantities;
    }

    private static IQuantity normalizeQuantity1(IQuantity quantity) {
        double resultValue;
        IUnit resultUnit;
        block2: {
            double absVal;
            double currentValue;
            IUnit currentUnit;
            block3: {
                currentUnit = quantity.getUnit();
                currentValue = quantity.getAmount();
                resultUnit = currentUnit;
                resultValue = currentValue;
                absVal = Math.abs(currentValue);
                if (absVal == 0.0) break block2;
                if (!(absVal > 1.0)) break block3;
                IUnit superUnit = currentUnit.getSuperUnit();
                while (superUnit != null && Math.abs(currentValue) > (double)currentUnit.getConversionFactor().intValue()) {
                    currentValue /= (double)currentUnit.getConversionFactor().intValue();
                    currentUnit = superUnit;
                    superUnit = currentUnit.getSuperUnit();
                    if (!currentUnit.getDisplay().booleanValue()) continue;
                    resultUnit = currentUnit;
                    resultValue = currentValue;
                }
                break block2;
            }
            if (!(absVal < 1.0)) break block2;
            boolean displayableSubUnitFound = false;
            IUnit subUnit = currentUnit.getSubUnit();
            while (subUnit != null && (!displayableSubUnitFound || Math.abs(currentValue) < 1.0)) {
                currentValue *= (double)subUnit.getConversionFactor().intValue();
                currentUnit = subUnit;
                subUnit = currentUnit.getSubUnit();
                if (!currentUnit.getDisplay().booleanValue()) continue;
                displayableSubUnitFound = true;
                resultUnit = currentUnit;
                resultValue = currentValue;
            }
        }
        return quantity.newQuantity(resultValue, resultUnit);
    }

    private static IStoreQuantity max1(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantity, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        if (q1.getUnit().equals(q2.getUnit())) {
            if (q1.getAmount() >= q2.getAmount()) {
                return q1;
            }
            return q2;
        }
        IStoreQuantity sub = UnitCalculator.subtractQuantitiesNormal(article, q1, q1PackagingQuantity, q2, q2PackagingQuantity);
        if (sub.getAmount() >= 0L) {
            return q1;
        }
        return q2;
    }

    private static IStoreQuantity min1(IBasicArticle article, IStoreQuantity q1, List<? extends IPackagingQuantity> q1PackagingQuantity, IStoreQuantity q2, List<? extends IPackagingQuantity> q2PackagingQuantity) {
        if (q1.getUnit().equals(q2.getUnit())) {
            if (q1.getAmount() <= q2.getAmount()) {
                return q1;
            }
            return q2;
        }
        IStoreQuantity sub = UnitCalculator.subtractQuantitiesNormal(article, q1, q1PackagingQuantity, q2, q2PackagingQuantity);
        if (sub.getAmount() <= 0L) {
            return q1;
        }
        return q2;
    }

    private static boolean isUnitInArticlePackingTable1(IBasicArticle article, IUnit targetUnit, List<? extends IPackagingQuantity> packagingQuantities) {
        for (IPackagingQuantity iPackagingQuantity : packagingQuantities) {
            if (!UnitCalculator.isConvertible(targetUnit, iPackagingQuantity.getUnit())) continue;
            return true;
        }
        return false;
    }

    public static IStoreQuantity convertToStoreQuantity(IQuantity quantity) {
        Double amount = quantity.getAmount();
        IUnit currentUnit = quantity.getUnit();
        if (amount > 100.0) {
            return quantity.newStoreQuantity(amount.longValue(), currentUnit);
        }
        if (currentUnit.getSubUnit() != null) {
            amount = amount * (double)currentUnit.getSubUnit().getConversionFactor().intValue();
            currentUnit = currentUnit.getSubUnit();
            if (amount > 100.0) {
                return quantity.newStoreQuantity(amount.longValue(), currentUnit);
            }
            if (currentUnit.getSubUnit() != null) {
                amount = amount * (double)currentUnit.getSubUnit().getConversionFactor().intValue();
                currentUnit = currentUnit.getSubUnit();
            }
            return quantity.newStoreQuantity(amount.longValue(), currentUnit);
        }
        return quantity.newStoreQuantity(amount.longValue(), currentUnit);
    }

    public static IQuantity addQuantity(IQuantity q1, IQuantity q2) {
        double conversionFactorForRecipe = UnitCalculator.getConversionFactorForRecipe(q2, q1.getUnit());
        return q1.newQuantity(conversionFactorForRecipe + q1.getAmount(), q1.getUnit());
    }
}

