/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.json;

import ch.icit.pegasus.server.core.json.JsonConverter;
import ch.icit.pegasus.server.core.json.JsonObject;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import ch.icit.util.TypeInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonMap {
    private Map<String, Object> references = new HashMap<String, Object>();

    public Object readJson(String json, JsonConverter converter) throws IOException, ClassNotFoundException, InvokerException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(json));
        ArrayList<String> attributeTuples = new ArrayList<String>();
        this.extractBlocks(bufferedReader, "\t\"", "}", attributeTuples);
        HashMap<String, String> pairs = new HashMap<String, String>();
        this.extractPairs(attributeTuples, pairs);
        String mainClass = this.getAsClassName("__dtype", pairs);
        Class<?> mainClazz = Class.forName(mainClass);
        JsonObject mainObject = (JsonObject)Invoker.instantiate(mainClazz);
        String referencesValue = (String)pairs.get("__references");
        ArrayList<String> referencedObjects = new ArrayList<String>();
        this.extractBlocks(new BufferedReader(new StringReader(referencesValue)), "\t\t\t\"", "\t\t\t\t}", referencedObjects);
        System.out.println("referenced objects parsed");
        for (String referencedObject : referencedObjects) {
            int s = referencedObject.indexOf("\"");
            int e = referencedObject.indexOf("\"", s + 1);
            String objectId = referencedObject.substring(s + 1, e);
            bufferedReader = new BufferedReader(new StringReader(referencedObject));
            ArrayList<String> referencedObjectsAttributes = new ArrayList<String>();
            this.extractBlocks(bufferedReader, "\t\t\t\t\t\"", "\t\t\t\t}", referencedObjectsAttributes);
            HashMap<String, String> referencePairs = new HashMap<String, String>();
            this.extractPairs(referencedObjectsAttributes, referencePairs);
            String referencedClass = this.getAsClassName("__dtype", referencePairs);
            Class<?> referencedClazz = Class.forName(referencedClass);
            Object refObject = Invoker.instantiate(referencedClazz);
            this.references.put(objectId, refObject);
        }
        System.out.println("Empty References are ready");
        this.extractFields(converter, pairs, mainClazz, mainObject, 1);
        System.out.println("Main Object loaded");
        return mainObject;
    }

    private void extractFields(JsonConverter converter, Map<String, String> pairs, Class<?> mainObjectClass, JsonObject mainObject, int level) throws InvokerException, IOException, ClassNotFoundException {
        for (Field field : Invoker.getAllFields(mainObjectClass, null)) {
            Class fieldType = Invoker.getFieldType((String)field.getName(), mainObjectClass);
            TypeInfo typeInfo = Invoker.getGenericTypeInfo((Field)field);
            if (JsonObject.class.isAssignableFrom(fieldType)) {
                this.handleJsonObject(converter, mainObject, field, fieldType, pairs);
                continue;
            }
            if (List.class.isAssignableFrom(fieldType)) {
                this.handleList(converter, mainObject, field, typeInfo, fieldType, pairs.get(field.getName()), false, level);
                continue;
            }
            if (Set.class.isAssignableFrom(fieldType)) {
                this.handleSet(converter, mainObject, field, typeInfo, fieldType, pairs.get(field.getName()), false, level);
                continue;
            }
            if (Map.class.isAssignableFrom(fieldType)) {
                this.handleMap(converter, mainObject, field, typeInfo, fieldType, pairs.get(field.getName()), false, level);
                continue;
            }
            this.writePrimitiveValueToField(pairs, mainObject, field, fieldType);
        }
    }

    private void extractPairs(List<String> attributeTuples, Map<String, String> pairs) {
        for (String attributeTuple : attributeTuples) {
            attributeTuple = attributeTuple.trim();
            int s = attributeTuple.indexOf("\"");
            int e = attributeTuple.indexOf("\"", s + 1);
            String attributeName = attributeTuple.substring(s + 1, e);
            String attributeValue = attributeTuple.substring(e + 1);
            if (attributeValue.endsWith(",")) {
                attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
            }
            attributeValue = attributeValue.substring(2);
            attributeValue = attributeValue.trim();
            pairs.put(attributeName, attributeValue);
        }
    }

    private boolean extractBlocks(BufferedReader bufferedReader, String startPattern, String endPattern, List<String> attributeTuples) throws IOException {
        return this.extractBlocks(bufferedReader, startPattern, endPattern, attributeTuples, false, null);
    }

    private boolean extractBlocks(BufferedReader bufferedReader, String startPattern, String endPattern, List<String> attributeTuples, boolean checkEmbedded, String embeddedPattern) throws IOException {
        String line;
        boolean firstLine = true;
        boolean isEmbedded = false;
        String currentAttributeValue = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (firstLine) {
                firstLine = false;
                continue;
            }
            if (line.startsWith(startPattern)) {
                if (currentAttributeValue != null) {
                    attributeTuples.add(currentAttributeValue);
                }
                if (checkEmbedded && line.contains("}")) {
                    isEmbedded = true;
                }
                currentAttributeValue = line;
                continue;
            }
            if (line.equals(endPattern)) {
                if (currentAttributeValue == null) continue;
                attributeTuples.add(currentAttributeValue);
                continue;
            }
            if (checkEmbedded && line.contains("\"value\"") && line.contains("{")) {
                isEmbedded = true;
            }
            currentAttributeValue = currentAttributeValue + "\n" + line;
        }
        return isEmbedded;
    }

    private void handleMap(JsonConverter converter, Object mainObject, Field field, TypeInfo keyTypeInfo, Class<?> fieldType, String mapValue, boolean isInner, int level) throws InvokerException, IOException, ClassNotFoundException {
        TypeInfo genericTypeInfoKey = keyTypeInfo;
        if (genericTypeInfoKey.getActualTypes().isEmpty()) {
            throw new IllegalStateException("Map without generic type information is not allowed");
        }
        TypeInfo keyItemTypeInfo = (TypeInfo)genericTypeInfoKey.getActualTypes().get(0);
        Class keyItemClass = ((TypeInfo)genericTypeInfoKey.getActualTypes().get(0)).getRawType();
        TypeInfo valueItemTypeInfo = (TypeInfo)genericTypeInfoKey.getActualTypes().get(0);
        Class valueItemClass = ((TypeInfo)genericTypeInfoKey.getActualTypes().get(0)).getRawType();
        boolean isKeyEmbedded = true;
        ArrayList<String> listValues = new ArrayList<String>();
        if (JsonObject.class.isAssignableFrom(keyItemClass)) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(mapValue));
            isKeyEmbedded = this.extractBlocks(bufferedReader, this.getLevelString(level + 1) + "{", this.getLevelString(level) + "]", listValues, true, "}");
        } else {
            isKeyEmbedded = false;
            this.extractBlocks(new BufferedReader(new StringReader(mapValue)), this.getLevelString(level + 1) + "{", this.getLevelString(level) + "]", listValues);
        }
        HashMap<Object, Object> newList = new HashMap<Object, Object>();
        for (String attributeTuple : listValues) {
            Object key = this.readValue(converter, field, fieldType, "\"key\"", level, keyItemTypeInfo, keyItemClass, isKeyEmbedded, listValues, newList, attributeTuple);
            Object value = this.readValue(converter, field, fieldType, "\"value\"", level, valueItemTypeInfo, valueItemClass, isKeyEmbedded, listValues, newList, attributeTuple);
            newList.put(key, value);
        }
        Invoker.setFieldValue((Field)field, newList, (Object)mainObject, (boolean)true);
    }

    private Object readValue(JsonConverter converter, Field field, Class<?> fieldType, String valueName, int level, TypeInfo keyItemTypeInfo, Class<?> keyItemClass, boolean isEmbedded, List<String> listValues, Map newList, String attributeTuple) throws InvokerException, IOException, ClassNotFoundException {
        if (attributeTuple.contains(valueName)) {
            int s = attributeTuple.indexOf(valueName);
            int e = attributeTuple.indexOf("[", s);
            int b = attributeTuple.indexOf("\n", s);
            if (e != -1 && e < b) {
                b = attributeTuple.lastIndexOf("]");
                String innerList = attributeTuple.substring(e, b + 1);
                if (List.class.isAssignableFrom(keyItemClass)) {
                    return this.handleList(converter, newList, field, keyItemTypeInfo, fieldType, innerList, true, level + 2);
                }
                if (Set.class.isAssignableFrom(keyItemClass)) {
                    return this.handleSet(converter, newList, field, keyItemTypeInfo, fieldType, innerList, true, level + 2);
                }
                throw new IllegalStateException();
            }
            if (isEmbedded) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(attributeTuple));
                boolean firstLine = true;
                String currentAttributeValue = null;
                HashMap<String, String> embeddedPairs = new HashMap<String, String>();
                while ((line = bufferedReader.readLine()) != null) {
                    if (firstLine) {
                        firstLine = false;
                        continue;
                    }
                    String[] parts = line.split(":");
                    if (parts.length > 1) {
                        String attributeName = parts[0];
                        String attributeValue = parts[1];
                        attributeName = attributeName.trim();
                        if ((attributeValue = attributeValue.trim()).endsWith(",")) {
                            attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
                        }
                        attributeName = attributeName.substring(1, attributeName.length() - 1);
                        embeddedPairs.put(attributeName, attributeValue);
                    }
                    if (line.startsWith("\t\t{")) {
                        if (currentAttributeValue != null) {
                            listValues.add(currentAttributeValue);
                        }
                        currentAttributeValue = line;
                        continue;
                    }
                    if (line.equals("\t]")) {
                        if (currentAttributeValue == null) continue;
                        listValues.add(currentAttributeValue);
                        continue;
                    }
                    currentAttributeValue = currentAttributeValue + "\n" + line;
                }
                String embeddedClassName = this.getAsClassName("__dtype", embeddedPairs);
                Class<?> embeddedItemClass = Class.forName(embeddedClassName);
                JsonObject embeddedListObject = (JsonObject)Invoker.instantiate(embeddedItemClass);
                for (Field embeddedField : Invoker.getAllFields(embeddedItemClass, null)) {
                    Class embeddedFieldType = Invoker.getFieldType((String)embeddedField.getName(), embeddedItemClass);
                    if (JsonObject.class.isAssignableFrom(embeddedFieldType)) {
                        JsonObject fieldObject = (JsonObject)Invoker.instantiate((Class)embeddedFieldType);
                        if (fieldObject.isEmbedded()) {
                            throw new IllegalStateException("Embedded blocks within embedded blocks are not allowed");
                        }
                        if (converter.isReferenceField(embeddedField)) {
                            String embeddedFieldId = this.getAsString(embeddedField.getName(), embeddedPairs);
                            Object referencedField = converter.getReferencedField(embeddedFieldId);
                            Invoker.setFieldValue((Field)embeddedField, (Object)referencedField, (Object)embeddedListObject, (boolean)true);
                            continue;
                        }
                        String idName = this.getAsString(embeddedField.getName(), embeddedPairs);
                        Object object = this.references.get(idName);
                        Invoker.setFieldValue((Field)embeddedField, (Object)object, (Object)embeddedListObject, (boolean)true);
                        continue;
                    }
                    this.writePrimitiveValueToField(embeddedPairs, embeddedListObject, embeddedField, embeddedFieldType);
                }
                return embeddedListObject;
            }
            s = attributeTuple.indexOf(valueName);
            e = attributeTuple.indexOf("\"", s + 1);
            String attributeName = attributeTuple.substring(s + 1, e);
            s = attributeTuple.indexOf("\"", e + 1);
            if (s != -1) {
                e = attributeTuple.indexOf("\"", s + 1);
                String refValue = attributeTuple.substring(s + 1, e);
                if (converter.isReferenceField(field)) {
                    Object referencedField = converter.getReferencedField(refValue);
                    return referencedField;
                }
                Object object = this.references.get(refValue);
                return object;
            }
            s = attributeTuple.indexOf(":", e + 1);
            e = attributeTuple.indexOf("}", s + 1);
            String attributeValue = attributeTuple.substring(s + 1, e);
            if ((attributeValue = attributeValue.trim()).equals("null")) {
                return null;
            }
            Object primitiveItem = this.createPrimitiveItem(keyItemClass, attributeValue);
            if (primitiveItem != null) {
                return primitiveItem;
            }
        }
        return null;
    }

    private Object handleList(JsonConverter converter, Object mainObject, Field field, TypeInfo typeInfo, Class<?> fieldType, String listValue, boolean isInner, int level) throws InvokerException, IOException, ClassNotFoundException {
        return this.handleCollection(converter, mainObject, field, typeInfo, fieldType, listValue, true, isInner, level);
    }

    private Object handleSet(JsonConverter converter, Object mainObject, Field field, TypeInfo typeInfo, Class<?> fieldType, String listValue, boolean isInner, int level) throws InvokerException, IOException, ClassNotFoundException {
        return this.handleCollection(converter, mainObject, field, typeInfo, fieldType, listValue, false, isInner, level);
    }

    private Object handleCollection(JsonConverter converter, Object mainObject, Field field, TypeInfo typeInfo, Class<?> fieldType, String listValue, boolean isList, boolean isInner, int level) throws InvokerException, IOException, ClassNotFoundException {
        BufferedReader bufferedReader;
        TypeInfo genericTypeInfo = typeInfo;
        if (genericTypeInfo.getActualTypes().isEmpty()) {
            throw new IllegalStateException("List without generic type information is not allowed");
        }
        TypeInfo childTypeInfo = (TypeInfo)genericTypeInfo.getActualTypes().get(0);
        Class listItemType = ((TypeInfo)genericTypeInfo.getActualTypes().get(0)).getRawType();
        boolean isEmbedded = true;
        ArrayList<String> listValues = new ArrayList<String>();
        if (JsonObject.class.isAssignableFrom(listItemType)) {
            bufferedReader = new BufferedReader(new StringReader(listValue));
            isEmbedded = this.extractBlocks(bufferedReader, this.getLevelString(level + 1) + "{", this.getLevelString(level) + "]", listValues, true, "}");
        } else {
            isEmbedded = false;
            this.extractBlocks(new BufferedReader(new StringReader(listValue)), this.getLevelString(level + 1) + "{", this.getLevelString(level) + "]", listValues);
        }
        AbstractCollection newList = isList ? new ArrayList() : new HashSet();
        for (String attributeTuple : listValues) {
            Object primitiveItem;
            if (!attributeTuple.contains("\"value\"")) continue;
            int s = attributeTuple.indexOf("\"value\"");
            int e = attributeTuple.indexOf("[", s);
            int b = attributeTuple.indexOf("\n", s);
            if (e != -1 && e < b) {
                b = attributeTuple.lastIndexOf("]");
                String innerList = attributeTuple.substring(e, b + 1);
                if (List.class.isAssignableFrom(listItemType)) {
                    this.handleList(converter, newList, field, childTypeInfo, fieldType, innerList, true, level + 2);
                    continue;
                }
                if (!Set.class.isAssignableFrom(listItemType)) continue;
                this.handleSet(converter, newList, field, childTypeInfo, fieldType, innerList, true, level + 2);
                continue;
            }
            if (isEmbedded) {
                String line;
                bufferedReader = new BufferedReader(new StringReader(attributeTuple));
                boolean firstLine = true;
                String currentAttributeValue = null;
                HashMap<String, String> embeddedPairs = new HashMap<String, String>();
                while ((line = bufferedReader.readLine()) != null) {
                    if (firstLine) {
                        firstLine = false;
                        continue;
                    }
                    String[] parts = line.split(":");
                    if (parts.length > 1) {
                        String attributeName = parts[0];
                        String attributeValue = parts[1];
                        attributeName = attributeName.trim();
                        if ((attributeValue = attributeValue.trim()).endsWith(",")) {
                            attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
                        }
                        attributeName = attributeName.substring(1, attributeName.length() - 1);
                        embeddedPairs.put(attributeName, attributeValue);
                    }
                    if (line.startsWith("\t\t{")) {
                        if (currentAttributeValue != null) {
                            listValues.add(currentAttributeValue);
                        }
                        currentAttributeValue = line;
                        continue;
                    }
                    if (line.equals("\t]")) {
                        if (currentAttributeValue == null) continue;
                        listValues.add(currentAttributeValue);
                        continue;
                    }
                    currentAttributeValue = currentAttributeValue + "\n" + line;
                }
                String embeddedClassName = this.getAsClassName("__dtype", embeddedPairs);
                Class<?> embeddedItemClass = Class.forName(embeddedClassName);
                JsonObject embeddedListObject = (JsonObject)Invoker.instantiate(embeddedItemClass);
                newList.add(embeddedListObject);
                for (Field embeddedField : Invoker.getAllFields(embeddedItemClass, null)) {
                    Class embeddedFieldType = Invoker.getFieldType((String)embeddedField.getName(), embeddedItemClass);
                    if (JsonObject.class.isAssignableFrom(embeddedFieldType)) {
                        JsonObject fieldObject = (JsonObject)Invoker.instantiate((Class)embeddedFieldType);
                        if (fieldObject.isEmbedded()) {
                            throw new IllegalStateException("Embedded blocks within embedded blocks are not allowed");
                        }
                        if (converter.isReferenceField(embeddedField)) {
                            String embeddedFieldId = this.getAsString(embeddedField.getName(), embeddedPairs);
                            Object referencedField = converter.getReferencedField(embeddedFieldId);
                            Invoker.setFieldValue((Field)embeddedField, (Object)referencedField, (Object)embeddedListObject, (boolean)true);
                            continue;
                        }
                        String idName = this.getAsString(embeddedField.getName(), embeddedPairs);
                        Object object = this.references.get(idName);
                        Invoker.setFieldValue((Field)embeddedField, (Object)object, (Object)embeddedListObject, (boolean)true);
                        continue;
                    }
                    this.writePrimitiveValueToField(embeddedPairs, embeddedListObject, embeddedField, embeddedFieldType);
                }
                continue;
            }
            s = attributeTuple.indexOf("\"");
            e = attributeTuple.indexOf("\"", s + 1);
            String attributeName = attributeTuple.substring(s + 1, e);
            s = attributeTuple.indexOf("\"", e + 1);
            if (s != -1) {
                e = attributeTuple.indexOf("\"", s + 1);
                String refValue = attributeTuple.substring(s + 1, e);
                if (converter.isReferenceField(field)) {
                    Object referencedField = converter.getReferencedField(refValue);
                    newList.add(referencedField);
                    continue;
                }
                Object object = this.references.get(refValue);
                newList.add(object);
                continue;
            }
            s = attributeTuple.indexOf(":", e + 1);
            e = attributeTuple.indexOf("}", s + 1);
            String attributeValue = attributeTuple.substring(s + 1, e);
            if ((attributeValue = attributeValue.trim()).equals("null") || (primitiveItem = this.createPrimitiveItem(listItemType, attributeValue)) == null) continue;
            newList.add(primitiveItem);
        }
        if (isInner) {
            ((Collection)mainObject).add(newList);
            return newList;
        }
        Invoker.setFieldValue((Field)field, newList, (Object)mainObject, (boolean)true);
        return newList;
    }

    private Object createPrimitiveItem(Class<?> listItemType, String attributeValue) {
        if (attributeValue.equals("null")) {
            return null;
        }
        if (listItemType.equals(Integer.class)) {
            Integer value = Integer.valueOf(attributeValue);
            return value;
        }
        if (listItemType.equals(Long.class)) {
            Long value = Long.valueOf(attributeValue);
            return value;
        }
        if (listItemType.equals(Double.class)) {
            Double value = Double.valueOf(attributeValue);
            return value;
        }
        if (listItemType.equals(Boolean.class)) {
            Boolean value = Boolean.valueOf(attributeValue);
            return value;
        }
        if (listItemType.equals(String.class)) {
            String value = attributeValue;
            return value;
        }
        throw new IllegalArgumentException("Type " + listItemType.getName() + " is not supported");
    }

    private void writePrimitiveValueToField(Map<String, String> nameToValueMap, JsonObject fieldOwningParent, Field field, Class<?> fieldType) throws InvokerException {
        if (fieldType.equals(Integer.class)) {
            Integer value = this.getAsInteger(field.getName(), nameToValueMap);
            Invoker.setFieldValue((Field)field, (Object)value, (Object)fieldOwningParent, (boolean)true);
        } else if (fieldType.equals(Long.class)) {
            Long value = this.getAsLong(field.getName(), nameToValueMap);
            Invoker.setFieldValue((Field)field, (Object)value, (Object)fieldOwningParent, (boolean)true);
        } else if (fieldType.equals(Double.class)) {
            Double value = this.getAsDouble(field.getName(), nameToValueMap);
            Invoker.setFieldValue((Field)field, (Object)value, (Object)fieldOwningParent, (boolean)true);
        } else if (fieldType.equals(Boolean.class)) {
            Boolean value = this.getAsBoolean(field.getName(), nameToValueMap);
            Invoker.setFieldValue((Field)field, (Object)value, (Object)fieldOwningParent, (boolean)true);
        } else if (fieldType.equals(String.class)) {
            String value = this.getAsString(field.getName(), nameToValueMap);
            Invoker.setFieldValue((Field)field, (Object)value, (Object)fieldOwningParent, (boolean)true);
        } else {
            throw new IllegalArgumentException("Type " + fieldType.getName() + " is not supported");
        }
    }

    private void handleJsonObject(JsonConverter converter, Object fieldOwningParent, Field fieldOnParent, Class<?> fieldClass, Map<String, String> pairs) throws InvokerException, IOException, ClassNotFoundException {
        JsonObject instantiate = (JsonObject)Invoker.instantiate(fieldClass);
        if (instantiate.isEmbedded()) {
            String content = this.getAsString(fieldOnParent.getName(), pairs);
            if (content == null) {
                return;
            }
            ArrayList<String> embeddedFields = new ArrayList<String>();
            HashMap<String, String> embeddedPairs = new HashMap<String, String>();
            this.extractBlocks(new BufferedReader(new StringReader(content)), "\t\t\"", "\t}", embeddedFields, false, null);
            for (String embeddedField : embeddedFields) {
                embeddedField = embeddedField.trim();
                int s = embeddedField.indexOf("\"");
                int e = embeddedField.indexOf("\"", s + 1);
                String attributeName = embeddedField.substring(s + 1, e);
                String attributeValue = embeddedField.substring(e + 1);
                if (attributeValue.endsWith(",")) {
                    attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
                }
                attributeValue = attributeValue.substring(2, attributeValue.length());
                attributeValue = attributeValue.trim();
                embeddedPairs.put(attributeName, attributeValue);
            }
            String embeddedClass = this.getAsClassName("__dtype", embeddedPairs);
            Class<?> embeddedClazz = Class.forName(embeddedClass);
            JsonObject embeddedObject = (JsonObject)Invoker.instantiate(embeddedClazz);
            Invoker.setFieldValue((Field)fieldOnParent, (Object)embeddedObject, (Object)fieldOwningParent, (boolean)true);
            for (Field embeddedField : Invoker.getAllFields(embeddedClazz, null)) {
                Class embeddedFieldType = Invoker.getFieldType((String)embeddedField.getName(), embeddedClazz);
                if (JsonObject.class.isAssignableFrom(embeddedFieldType)) {
                    JsonObject fieldObject = (JsonObject)Invoker.instantiate((Class)embeddedFieldType);
                    if (fieldObject.isEmbedded()) {
                        throw new IllegalStateException("Embedded blocks within embedded blocks are not allowed");
                    }
                    if (converter.isReferenceField(embeddedField)) {
                        String embeddedFieldId = this.getAsString(embeddedField.getName(), embeddedPairs);
                        Object referencedField = converter.getReferencedField(embeddedFieldId);
                        Invoker.setFieldValue((Field)embeddedField, (Object)referencedField, (Object)embeddedObject, (boolean)true);
                        continue;
                    }
                    String idName = this.getAsString(embeddedField.getName(), embeddedPairs);
                    Object object = this.references.get(idName);
                    Invoker.setFieldValue((Field)embeddedField, (Object)object, (Object)embeddedObject, (boolean)true);
                    continue;
                }
                this.writePrimitiveValueToField(embeddedPairs, embeddedObject, embeddedField, embeddedFieldType);
            }
        } else if (converter.isReferenceField(fieldOnParent)) {
            String idName = this.getAsString(fieldOnParent.getName(), pairs);
            Object referencedField = converter.getReferencedField(idName);
            Invoker.setFieldValue((Field)fieldOnParent, (Object)referencedField, (Object)fieldOwningParent, (boolean)true);
        } else {
            String idName = this.getAsString(fieldOnParent.getName(), pairs);
            Object object = this.references.get(idName);
            Invoker.setFieldValue((Field)fieldOnParent, (Object)object, (Object)fieldOwningParent, (boolean)true);
        }
    }

    public String getAsClassName(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public Boolean getAsBoolean(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equals("null")) {
            return null;
        }
        return Boolean.valueOf(s);
    }

    public Long getAsLong(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equals("null")) {
            return null;
        }
        return Long.valueOf(s);
    }

    public Double getAsDouble(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equals("null")) {
            return null;
        }
        return Double.valueOf(s);
    }

    public Integer getAsInteger(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equals("null")) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public String getAsString(String key, Map<String, String> pairs) {
        String s = pairs.get(key);
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.equals("null")) {
            return null;
        }
        return s;
    }

    private String getLevelString(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }
}

