/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.util;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherCrypto {
    private static Logger log = LoggerFactory.getLogger(CipherCrypto.class);
    private String key = null;
    private SecretKeySpec secretKeySpec;
    private Cipher deCryptCipher;
    private Cipher enCryptCipher;
    private static final String aes = "AES";
    private static int keyValue = 256;

    public String generateKey() throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance(aes);
        kgen.init(keyValue);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        String key = this.convertHexToStringValue(raw);
        return key;
    }

    public boolean initCipher(String key) {
        try {
            if (key != null && !key.isEmpty()) {
                this.secretKeySpec = new SecretKeySpec(this.hexStringToByteArray(key), aes);
                this.enCryptCipher = Cipher.getInstance(aes);
                this.enCryptCipher.init(1, this.secretKeySpec);
                this.deCryptCipher = Cipher.getInstance(aes);
                this.deCryptCipher.init(2, this.secretKeySpec);
                return true;
            }
            String errorText = "Unable to initCipher(): key not exists!";
            log.error(errorText);
        }
        catch (Exception e) {
            String errorText = "Unable to initCipher():" + e.getMessage();
            log.error(errorText);
        }
        return false;
    }

    public String encrypt(String code) {
        String encryptedText = null;
        try {
            byte[] encrypted = this.enCryptCipher.doFinal(code.getBytes());
            encryptedText = this.convertHexToStringValue(encrypted);
        }
        catch (Exception e) {
            log.error("Unable to encrypt():" + e.getMessage());
        }
        return encryptedText;
    }

    public String decrypt(String code) {
        boolean isHexCode = this.testForCode(code);
        String result = null;
        try {
            if (isHexCode) {
                byte[] clearText = this.deCryptCipher.doFinal(this.hexStringToByteArray(code));
                result = new String(clearText);
            }
        }
        catch (Exception e) {
            log.error("decrypt:" + e.getMessage());
        }
        return result;
    }

    private boolean testForCode(String code) {
        boolean result = true;
        for (int i = 0; i < code.length(); ++i) {
            char ch = code.charAt(i);
            int digit = Character.digit(ch, 16);
            if (digit != -1) continue;
            result = false;
        }
        return result;
    }

    public String convertHexToStringValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public byte[] hexStringToByteArray(String hex) {
        int l = hex.length();
        byte[] data = new byte[l / 2];
        for (int i = 0; i < l; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}

