/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.builder;

import ch.icit.utils.GTINCategory;

public class BarcodeBuilderEAN128 {
    public String readArticleNumberFromContent(String content) {
        if (content.length() != 15) {
            throw new IllegalStateException("Barcode Length is not correct");
        }
        String articleNo = content.substring(content.length() - 15, content.length() - 10);
        return articleNo;
    }

    public String readChargeNumberFromContent(String content) {
        if (content.length() != 15) {
            throw new IllegalStateException("Barcode Length is not correct");
        }
        String chargeNo = content.substring(content.length() - 10, content.length() - 3);
        return chargeNo;
    }

    public String readSequenceNumberFromContent(String content) {
        if (content.length() != 15) {
            throw new IllegalStateException("Barcode Length is not correct");
        }
        String sequence = content.substring(content.length() - 3, content.length() - 0);
        return sequence;
    }

    public String createEAN128Barcode(String barcodeText, GTINCategory category, String company, boolean silent) {
        barcodeText = this.ensureStringLength(barcodeText, 15);
        StringBuilder str = new StringBuilder();
        str.append("10");
        company = this.ensureStringLength(company, 2);
        str.append(company);
        str.append(category.getId());
        str.append(barcodeText);
        return str.toString();
    }

    public String readContentOfEAN128(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 21) {
            usedBarcode = "0" + usedBarcode;
        }
        String barcodeText = usedBarcode.substring(usedBarcode.length() - 15, usedBarcode.length() - 0);
        return barcodeText;
    }

    public GTINCategory readCategoryOfEAN123(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 21) {
            usedBarcode = "0" + usedBarcode;
        }
        String categoryId = usedBarcode.substring(usedBarcode.length() - 17, usedBarcode.length() - 15);
        for (GTINCategory value : GTINCategory.values()) {
            if (!value.getId().equals(categoryId)) continue;
            return value;
        }
        throw new IllegalStateException("Unknown Barcode");
    }

    public String readCompanyOfEAN123(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 21) {
            usedBarcode = "0" + usedBarcode;
        }
        String companyId = usedBarcode.substring(usedBarcode.length() - 19, usedBarcode.length() - 17);
        return companyId;
    }

    private String ensureStringLength(String text, int length) {
        String rtext = text;
        if (rtext.length() > length) {
            rtext = rtext.substring(0, length);
        }
        while (rtext.length() < length) {
            rtext = "0" + rtext;
        }
        return rtext;
    }

    public void validateBarcode(String barcode, GTINCategory expectedCategory, String expectedCompany, boolean silent) {
        String companyId;
        if (!this.validateBarcodeNotNull(barcode, silent)) {
            return;
        }
        String usedBarcode = barcode;
        while (usedBarcode.length() < 21) {
            usedBarcode = "0" + usedBarcode;
        }
        String barcodeText = usedBarcode.substring(usedBarcode.length() - 15, usedBarcode.length() - 0);
        String categoryId = usedBarcode.substring(usedBarcode.length() - 17, usedBarcode.length() - 15);
        if (!this.validateCategoryAndCompany(expectedCategory, expectedCompany, silent, categoryId, companyId = usedBarcode.substring(usedBarcode.length() - 19, usedBarcode.length() - 17))) {
            return;
        }
    }

    private boolean validateBarcodeNotNull(String barcode, boolean silent) {
        if (barcode == null || barcode.isEmpty()) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Barcode is empty");
        }
        return true;
    }

    private boolean validateCategoryAndCompany(GTINCategory category, String companyCode, boolean silent, String categoryId, String companyId) {
        if (!category.getId().equals(categoryId)) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("It's not a " + category.getName() + " Barcode");
        }
        if (!companyId.equals(companyCode)) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Third party Barcode scanned");
        }
        return true;
    }
}

