/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.PDFPrinter;
import ch.icit.util.PrintPdf;
import ch.icit.util.PrinterToolkitException;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.PrinterName;

public class PrinterToolkit {
    public static void printPDF(String path, String printer, boolean portrait, boolean withPrintDialog, int copies) throws PrinterToolkitException {
        PrinterToolkit.printPDF(path, PrinterToolkit.converterStringToPrintService(printer), portrait, withPrintDialog, copies);
    }

    public static void printPDF(String path, PrintService service, boolean portrait, boolean withPrintDialog, int copies) throws PrinterToolkitException {
        if (service == null) {
            throw new PrinterToolkitException("No Printer selected");
        }
        try {
            new PDFPrinter().doPrint(path, service, portrait, withPrintDialog, copies);
        }
        catch (IOException e) {
            throw new PrinterToolkitException(e);
        }
        catch (PrinterException e) {
            throw new PrinterToolkitException(e);
        }
        catch (Exception e) {
            throw new PrinterToolkitException(e);
        }
    }

    public static List<PrintService> getAvailablePrinters() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        ArrayList<PrintService> l = new ArrayList<PrintService>();
        for (PrintService printer : printServices) {
            l.add(printer);
        }
        return l;
    }

    public static List<String> getAvailablePrinterNames() {
        ArrayList<String> printerNames = new ArrayList<String>();
        for (PrintService ps : PrinterToolkit.getAvailablePrinters()) {
            String t = PrinterToolkit.convertPrintServiceToString(ps);
            if (t == null) continue;
            printerNames.add(t);
        }
        return printerNames;
    }

    public static String convertPrintServiceToString(PrintService service) {
        if (service == null) {
            return null;
        }
        String t = service.getName();
        if (t.contains("Win32 Printer : ")) {
            t = t.replaceAll("Win32 : ", "");
        }
        t = t.trim();
        return t;
    }

    public static PrintService converterStringToPrintService(String name) {
        if (name != null) {
            String t;
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
            String smallName = name.toLowerCase();
            for (PrintService printer : printServices) {
                t = PrinterToolkit.convertPrintServiceToString(printer);
                if (t == null || !t.toLowerCase().equals(smallName)) continue;
                return printer;
            }
            for (PrintService printer : printServices) {
                t = PrinterToolkit.convertPrintServiceToString(printer);
                if (t == null || !t.toLowerCase().contains(smallName)) continue;
                return printer;
            }
        }
        return null;
    }

    public static PrintService getDefaultPrinter() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static PrintService getPrinter(String printerName) {
        HashAttributeSet set = new HashAttributeSet(new PrinterName(printerName, null));
        PrintService[] printers = PrintServiceLookup.lookupPrintServices(null, set);
        return printers.length < 1 ? null : printers[0];
    }

    public static String toMediasString(List<Media> medias) {
        StringBuilder mediasString = new StringBuilder();
        if (medias == null || medias.isEmpty()) {
            return "";
        }
        for (Media m : medias) {
            mediasString.append(m.getClass().getName()).append(":").append(m.getValue()).append(",");
        }
        int length = mediasString.length();
        mediasString.replace(length - 2, length - 1, "");
        return mediasString.toString();
    }

    public static List<Media> getMedia(String medias) throws PrinterToolkitException {
        ArrayList<Media> media = new ArrayList<Media>();
        if (medias == null) {
            return media;
        }
        StringTokenizer m = new StringTokenizer(medias, ",");
        boolean throwException = false;
        while (m.hasMoreTokens()) {
            try {
                StringTokenizer tok = new StringTokenizer(m.nextToken(), ":");
                if (tok.countTokens() != 2) {
                    throw new IOException("Invalid 'media' value!");
                }
                Class<?> mediaClass = Class.forName(tok.nextToken());
                Constructor<?> constructor = mediaClass.getDeclaredConstructor(Integer.TYPE);
                constructor.setAccessible(true);
                media.add((Media)constructor.newInstance(Integer.parseInt(tok.nextToken())));
            }
            catch (Exception exception) {}
        }
        if (throwException) {
            throw new PrinterToolkitException();
        }
        return media;
    }

    public static void printAtts(PrintService printer) {
        System.out.println("  attributes:");
        for (Attribute att : printer.getAttributes().toArray()) {
            System.out.println("    name: " + att.getName());
            System.out.println("      value: " + printer.getAttribute(att.getClass()));
        }
    }

    public static final void printMediaInfo(PrintService printer) {
        Media[] media = (Media[])printer.getSupportedAttributeValues(Media.class, null, null);
        System.out.println("    supported media:");
        for (Media m : media) {
            System.out.println("      " + m);
            System.out.println("        supported printable areas:");
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            aset.add(m);
            MediaPrintableArea[] areas = (MediaPrintableArea[])printer.getSupportedAttributeValues(MediaPrintableArea.class, null, aset);
            if (areas == null) continue;
            for (MediaPrintableArea area : areas) {
                if (area == null) continue;
                System.out.println("          " + area);
            }
        }
    }

    public static void printPDF(File r, PrintService service, int copies) throws PrinterToolkitException {
        PrinterToolkit.printPDF(r, service, copies, null);
    }

    public static void printPDF(File r, PrintService service, int copies, String trayName) throws PrinterToolkitException {
        try {
            new PrintPdf().print(new FileInputStream(r), "CATIT Print Job", service, copies, trayName);
        }
        catch (FileNotFoundException e) {
            throw new PrinterToolkitException(e.getMessage());
        }
        catch (IOException e) {
            throw new PrinterToolkitException(e.getMessage());
        }
        catch (PrinterException e) {
            throw new PrinterToolkitException(e.getMessage());
        }
        catch (PrintException e) {
            throw new PrinterToolkitException(e.getMessage());
        }
    }
}

