/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.ClassFilter;
import ch.icit.util.FieldFilter;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDump {
    static final Logger log = LoggerFactory.getLogger(ObjectDump.class);
    private final Object object;
    private final FieldFilter fieldFilter;
    private final ClassFilter classFilter;
    private final StringBuilder str;
    private Step currentStep;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String SKIPPED = "... skipped";
    private final HashSet<Object> cache;

    public ObjectDump(Object object, final String pkgPrefix) throws InvokerException {
        this(object, new FieldFilter(){

            @Override
            public boolean isFieldValid(Field field) {
                return !Modifier.isStatic(field.getModifiers());
            }
        }, new ClassFilter(){

            @Override
            public boolean isClassValid(Class<?> clazz) {
                return clazz.getCanonicalName().startsWith(pkgPrefix) && !Enum.class.isAssignableFrom(clazz);
            }
        });
    }

    public ObjectDump(Object object, FieldFilter fieldFilter, ClassFilter recursionFilter) throws InvokerException {
        this.object = object;
        this.fieldFilter = fieldFilter;
        this.classFilter = recursionFilter;
        this.str = new StringBuilder();
        this.cache = new HashSet();
        this.createDump();
    }

    private void createDump() throws InvokerException {
        this.currentStep = new Step(null);
        this.processObject(null, this.object, true);
    }

    private void processObject(Field field, Object obj, boolean isLast) throws InvokerException {
        String name = field == null ? null : field.getName();
        log.trace("process field '{}.{}')", new Object[]{obj == null ? null : obj.getClass().getSimpleName(), name});
        this.appendLine(name, obj != null ? obj.toString() : null, isLast);
        this.currentStep = new Step(this.currentStep);
        if (obj instanceof Collection) {
            this.processCollection((Collection)obj);
        } else if (obj instanceof Map) {
            this.processMap((Map)obj);
        } else {
            this.processSimpleObject(obj);
        }
        this.currentStep = this.currentStep.getParentStep();
    }

    private void processSimpleObject(Object obj) throws InvokerException {
        if (obj == null) {
            return;
        }
        if (!this.cache.add(obj)) {
            this.appendLine(null, SKIPPED, true);
            return;
        }
        List<Field> fields = Invoker.getAllFields(obj.getClass(), this.fieldFilter);
        this.processFields(obj, fields);
    }

    private void processCollection(Collection<?> obj) throws InvokerException {
        ArrayList objs2process = new ArrayList();
        for (Object o : obj) {
            if (o == null || !this.classFilter.isClassValid(o.getClass())) continue;
            objs2process.add(o);
        }
        int size = obj.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Object o : objs2process) {
            if (o == null) continue;
            this.processObject(null, o, ++i == size);
        }
    }

    private void processMap(Map<?, ?> obj) throws InvokerException {
    }

    private void processFields(Object obj, List<Field> fields) throws InvokerException {
        int siz = fields.size();
        for (Field field : fields) {
            this.processField(obj, field, --siz == 0);
        }
    }

    private void processField(Object obj, Field field, boolean isLast) throws InvokerException {
        Object value;
        try {
            value = Invoker.getFieldValue(field, obj, null, true);
        }
        catch (InvokerException e) {
            value = Invoker.getFieldValue(field, obj, null, false);
        }
        if (value != null && (this.classFilter.isClassValid(value.getClass()) || value instanceof Collection || value instanceof Map)) {
            this.processObject(field, value, isLast);
        } else {
            String name = field.getName();
            this.appendLine(name, value == null ? null : value.toString(), isLast);
        }
    }

    private void appendLine(String fieldName, String value, boolean lastEntry) {
        this.str.append(NEW_LINE);
        this.currentStep.append(this.str, lastEntry);
        if (fieldName != null) {
            this.str.append(fieldName).append(" = ");
        }
        this.str.append(value);
    }

    public String toString() {
        return this.str.toString();
    }

    private class Step {
        private final Step parentStep;
        private boolean finished = false;
        private static final String CHILD = "|-- ";
        private static final String LAST_CHILD = "`-- ";
        private static final String INDIRECT_CHILD = "|   ";
        private static final String EMPTY = "    ";

        Step(Step parentStep) {
            this.parentStep = parentStep;
        }

        private StringBuilder append0(StringBuilder str) {
            if (this.parentStep != null) {
                this.parentStep.append0(str);
                str.append(this.finished ? EMPTY : INDIRECT_CHILD);
            }
            return str;
        }

        StringBuilder append(StringBuilder str, boolean isLastEntry) {
            if (this.parentStep != null) {
                this.parentStep.append0(str);
                str.append(isLastEntry ? LAST_CHILD : CHILD);
                this.finished = isLastEntry;
            }
            return str;
        }

        public Step getParentStep() {
            return this.parentStep;
        }
    }
}

